/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.JOptionPane;

final class Model3D {
    ArrayList vertices;
    ArrayList tvertices;
    ArrayList lines;
    ArrayList primes;
    int nvertices;
    int w;
    int h;
    int zcmax;
    int eyeDistance;
    BigInteger volume;
    Matrix3D mat = new Matrix3D();
    boolean drawGlasses;
    boolean modelInFront;
    boolean isGreen;
    boolean thickLines;
    float xmin;
    float xmax;
    float ymin;
    float ymax;
    float zmin;
    float zmax;
    float xfac;

    int colorGray(float zvalue) {
        int colorFace = (int)(64.0f + 64.0f * zvalue / (float)this.zcmax);
        if (colorFace > 128) {
            colorFace = 128;
        }
        if (colorFace < 0) {
            colorFace = 0;
        }
        return colorFace;
    }

    Model3D() {
    }

    /*
     * Unable to fully structure code
     */
    Model3D(InputStream is) throws IOException, FileFormatException {
        this();
        this.tvertices = null;
        this.vertices = null;
        this.lines = null;
        inputStreamReader = new InputStreamReader(is);
        bufferedReader = new BufferedReader(inputStreamReader);
        st = new StreamTokenizer(bufferedReader);
        st.eolIsSignificant(true);
        st.commentChar(35);
        index = 0;
        block4: while (true) {
            switch (st.nextToken()) {
                case 10: {
                    continue block4;
                }
                case -2: {
                    x = 0.0;
                    y = 0.0;
                    z = 0.0;
                    x = st.nval;
                    if (st.nextToken() == -2) {
                        y = st.nval;
                        if (st.nextToken() == -2) {
                            z = st.nval;
                        }
                    }
                    this.addVert((float)x, (float)y, (float)z);
                    if (index > 0) {
                        this.addLine(index - 1, index);
                    }
                    ++index;
                    while (true) {
                        if (st.ttype != 10 && st.ttype != -1) ** break;
                        continue block4;
                        st.nextToken();
                    }
                }
            }
            break;
        }
        if (st.ttype != -1) {
            throw new FileFormatException(st.toString());
        }
        this.addLine(index - 1, 0);
        this.nvertices = this.vertices.size();
    }

    void addVert(float x, float y, float z) {
        if (this.vertices == null) {
            this.vertices = new ArrayList();
        }
        this.vertices.add(new float[]{x, y, z});
    }

    void addLine(int p1, int p2) {
        if (this.lines == null) {
            this.lines = new ArrayList();
            this.primes = new ArrayList();
        }
        HashSet<Integer> line = new HashSet<Integer>();
        line.add(new Integer(p1));
        line.add(new Integer(p2));
        this.lines.add(line);
        float[] vertex1 = (float[])this.vertices.get(p1);
        float[] vertex2 = (float[])this.vertices.get(p2);
        int length = Math.round(Math.abs(vertex1[0] - vertex2[0]) + Math.abs(vertex1[1] - vertex2[1]) + Math.abs(vertex1[2] - vertex2[2]));
        this.primes.add(new Integer(length));
    }

    private void setScalefactor() {
        float f2;
        float f1;
        float xw = this.xmax - this.xmin;
        float yw = this.ymax - this.ymin;
        float zw = this.zmax - this.zmin;
        if (yw > xw) {
            xw = yw;
        }
        if (zw > xw) {
            xw = zw;
        }
        this.xfac = 0.7f * ((f1 = (float)this.w / xw) < (f2 = (float)this.h / xw) ? f1 : f2);
        this.zcmax = (int)this.xfac;
    }

    void setWH(int w, int h) {
        this.w = w;
        this.h = h;
        this.setScalefactor();
    }

    void transform() {
        if (this.tvertices == null) {
            this.tvertices = new ArrayList();
        } else {
            this.tvertices.clear();
        }
        this.mat.scale(this.xfac, this.xfac, this.xfac);
        if (!this.drawGlasses) {
            this.mat.translate(this.w / 2, this.h / 2, 0.0f);
        }
        this.mat.transform(this.vertices, this.tvertices);
    }

    void paint(Graphics2D g, boolean right) {
        if (this.vertices == null || this.nvertices <= 0) {
            return;
        }
        if (right) {
            this.transform();
        }
        float a = this.eyeDistance;
        if (!right) {
            a = -a;
        }
        boolean red = right;
        float d = this.xfac;
        float d0 = this.xfac * 5.0f;
        float x = d0 - d;
        float cor = d0 / x;
        if (this.modelInFront) {
            x = d0 + d;
            cor = d0 / x;
        }
        for (Set line : this.lines) {
            Iterator lnit = line.iterator();
            Integer p1 = (Integer)lnit.next();
            Integer p2 = (Integer)lnit.next();
            int[] vertex1 = (int[])this.tvertices.get(p1);
            int[] vertex2 = (int[])this.tvertices.get(p2);
            int x1 = (int)((float)(this.w / 2) + a + x / ((float)vertex1[2] + d0) * ((float)vertex1[0] * cor - a));
            int x2 = (int)((float)(this.w / 2) + a + x / ((float)vertex2[2] + d0) * ((float)vertex2[0] * cor - a));
            int y1 = (int)((float)(this.h / 2) + x / ((float)vertex1[2] + d0) * (float)vertex1[1] * cor);
            int y2 = (int)((float)(this.h / 2) + x / ((float)vertex2[2] + d0) * (float)vertex2[1] * cor);
            if (red) {
                g.setColor(new Color(255, 0, 0));
            } else if (this.isGreen) {
                g.setColor(new Color(0, 255, 0));
            } else {
                g.setColor(new Color(0, 0, 255));
            }
            g.drawLine(x1, y1, x2, y2);
            if (!this.thickLines) continue;
            g.drawLine(x1 + 1, y1 + 1, x2 + 1, y2 + 1);
        }
    }

    void paint(Graphics g) {
        if (this.vertices == null || this.nvertices <= 0) {
            return;
        }
        this.transform();
        for (Set line : this.lines) {
            Iterator lnit = line.iterator();
            Integer p1 = (Integer)lnit.next();
            Integer p2 = (Integer)lnit.next();
            int[] vertex1 = (int[])this.tvertices.get(p1);
            int[] vertex2 = (int[])this.tvertices.get(p2);
            int cf = this.colorGray((vertex1[2] + vertex2[2]) / 2);
            g.setColor(new Color(cf, cf, cf));
            g.drawLine(vertex1[0], vertex1[1], vertex2[0], vertex2[1]);
            if (!this.thickLines) continue;
            g.drawLine(vertex1[0] + 1, vertex1[1] + 1, vertex2[0] + 1, vertex2[1] + 1);
        }
    }

    void printPrimesUsed() {
        int index = 1;
        String text = "Volume bounding box: " + this.volume + "\n\n";
        int size = this.primes.size();
        ArrayList sortedprimes = new ArrayList(this.primes);
        Collections.sort(sortedprimes);
        int smallestprime = (Integer)sortedprimes.get(0);
        int indexsmallest = this.primes.indexOf(new Integer(smallestprime));
        int direction = 0;
        boolean increasing = true;
        if (indexsmallest == 0) {
            direction = 1;
        } else if (indexsmallest == size - 1) {
            direction = -1;
        } else {
            int before = (Integer)this.primes.get(indexsmallest - 1);
            int after = (Integer)this.primes.get(indexsmallest + 1);
            if (after < before) {
                direction = 1;
            } else if (after > before) {
                direction = -1;
            } else {
                increasing = false;
            }
        }
        if (increasing) {
            int prime = smallestprime;
            for (int i = 1; i < size; ++i) {
                int nextprime;
                int newindex = (indexsmallest + direction * i) % size;
                if (newindex < 0) {
                    newindex += size;
                }
                if ((nextprime = ((Integer)this.primes.get(newindex)).intValue()) > prime) continue;
                increasing = false;
                break;
            }
        }
        if (increasing) {
            text = text + "Lengths form increasing list.\n";
            text = direction == 1 ? text + "Order specified by inputfile is increasing." : text + "Order specified by inputfile is decreasing.";
        } else {
            text = text + "At least two lengths are equal\nor not strictly increasing decreasing list.";
        }
        text = text + "\n\n";
        boolean inOrder = increasing;
        boolean arePrimes = true;
        int first = (Integer)sortedprimes.get(0);
        int second = (Integer)sortedprimes.get(1);
        int third = (Integer)sortedprimes.get(2);
        if (second == first + 1 && third == second + 1) {
            arePrimes = false;
        }
        if (increasing) {
            int prime;
            if (arePrimes) {
                prime = smallestprime;
                BigInteger Fprime = new BigInteger(String.valueOf(prime));
                if (Fprime.isProbablePrime(100)) {
                    text = text + "The first prime is " + prime + ".";
                    Iterator pit = sortedprimes.iterator();
                    pit.next();
                    while (pit.hasNext() && inOrder) {
                        prime = (Integer)pit.next();
                        BigInteger Nprime = new BigInteger(String.valueOf(prime));
                        inOrder = Fprime.nextProbablePrime().equals(Nprime);
                        Fprime = Nprime;
                        ++index;
                    }
                    if (inOrder) {
                        text = text + " The last prime is " + prime + ".\n";
                        text = text + "There are " + size + " primes in total, all consecutive.";
                    } else {
                        text = text + "\nLength: " + prime + " is either not prime or not the next prime.\n";
                        text = text + "There are " + String.valueOf(index - 1) + " primes which are consecutive.";
                    }
                } else {
                    text = text + "Smallest length: " + prime + " is not prime.";
                }
            } else {
                prime = smallestprime;
                text = text + "The first number is " + prime + ".";
                Iterator pit = sortedprimes.iterator();
                pit.next();
                while (pit.hasNext() && inOrder) {
                    int nprime = (Integer)pit.next();
                    inOrder = nprime == prime + 1;
                    prime = nprime;
                    ++index;
                }
                if (inOrder) {
                    text = text + " The last number is " + prime + ".\n";
                    text = text + "There are " + size + " natural numbers in total, all consecutive.";
                } else {
                    text = text + "\nLength: " + prime + " is not the next number.\n";
                    text = text + "There are " + String.valueOf(index - 1) + " numbers which are consecutive.";
                }
            }
        }
        if (inOrder) {
            JOptionPane.showMessageDialog(null, text, "Check Golygons", -1);
        } else {
            JOptionPane.showMessageDialog(null, text, "Check Golygons", 0);
        }
    }

    void findBB() {
        float ztmin;
        float ytmin;
        float xtmin;
        if (this.nvertices <= 0) {
            return;
        }
        float[] vertex = (float[])this.vertices.get(0);
        float xtmax = xtmin = vertex[0];
        float ytmax = ytmin = vertex[1];
        float ztmax = ztmin = vertex[2];
        ListIterator<float[]> lit = this.vertices.listIterator();
        while (lit.hasNext()) {
            float z;
            float y;
            vertex = (float[])lit.next();
            float x = vertex[0];
            if (x < xtmin) {
                xtmin = x;
            }
            if (x > xtmax) {
                xtmax = x;
            }
            if ((y = vertex[1]) < ytmin) {
                ytmin = y;
            }
            if (y > ytmax) {
                ytmax = y;
            }
            if ((z = vertex[2]) < ztmin) {
                ztmin = z;
            }
            if (!(z > ztmax)) continue;
            ztmax = z;
        }
        this.xmax = xtmax;
        this.xmin = xtmin;
        this.ymax = ytmax;
        this.ymin = ytmin;
        this.zmax = ztmax;
        this.zmin = ztmin;
        float widthx = this.xmax - this.xmin;
        float widthy = this.ymax - this.ymin;
        float widthz = this.zmax - this.zmin;
        this.volume = new BigInteger(String.valueOf((int)widthx));
        this.volume = this.volume.multiply(new BigInteger(String.valueOf((int)widthy)));
        this.volume = this.volume.multiply(new BigInteger(String.valueOf((int)widthz)));
        float width = widthx;
        if (widthy > width) {
            width = widthy;
        }
        if (widthz > width) {
            width = widthz;
        }
        float centerx = (this.xmax + this.xmin) / 2.0f;
        float centery = (this.ymax + this.ymin) / 2.0f;
        float centerz = (this.zmax + this.zmin) / 2.0f;
        lit = this.vertices.listIterator();
        while (lit.hasNext()) {
            vertex = (float[])lit.next();
            float[] newvertex = new float[]{(vertex[0] - centerx) / width * 2.0f, (vertex[1] - centery) / width * 2.0f, (vertex[2] - centerz) / width * 2.0f};
            lit.set(newvertex);
        }
        this.xmax = widthx / width;
        this.xmin = -this.xmax;
        this.ymax = widthy / width;
        this.ymin = -this.ymax;
        this.zmax = widthz / width;
        this.zmin = -this.zmax;
    }
}

