/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.ListIterator;

class Matrix3D {
    float xx = 1.0f;
    float xy;
    float xz;
    float xo;
    float yx;
    float yy = 1.0f;
    float yz;
    float yo;
    float zx;
    float zy;
    float zz = 1.0f;
    float zo;
    static final double pi = 3.14159265;

    Matrix3D() {
    }

    void inspect() {
        System.out.println(this.xx + "," + this.xy + "," + this.xz);
        System.out.println(this.yx + "," + this.yy + "," + this.yz);
        System.out.println(this.zx + "," + this.zy + "," + this.zz);
    }

    void scale(float f) {
        this.xx *= f;
        this.xy *= f;
        this.xz *= f;
        this.yx *= f;
        this.yy *= f;
        this.yz *= f;
        this.zx *= f;
        this.zy *= f;
        this.zz *= f;
    }

    void scale(float xf, float yf, float zf) {
        this.xx *= xf;
        this.xy *= xf;
        this.xz *= xf;
        this.yx *= yf;
        this.yy *= yf;
        this.yz *= yf;
        this.zx *= zf;
        this.zy *= zf;
        this.zz *= zf;
    }

    void translate(float x, float y, float z) {
        this.xo += x;
        this.yo += y;
        this.zo += z;
    }

    void yrot(double theta) {
        double ct = Math.cos(theta *= 0.017453292500000002);
        double st = Math.sin(theta);
        float Nxx = (float)((double)this.xx * ct + (double)this.zx * st);
        float Nxy = (float)((double)this.xy * ct + (double)this.zy * st);
        float Nxz = (float)((double)this.xz * ct + (double)this.zz * st);
        float Nzx = (float)((double)this.zx * ct - (double)this.xx * st);
        float Nzy = (float)((double)this.zy * ct - (double)this.xy * st);
        float Nzz = (float)((double)this.zz * ct - (double)this.xz * st);
        this.xx = Nxx;
        this.xy = Nxy;
        this.xz = Nxz;
        this.zx = Nzx;
        this.zy = Nzy;
        this.zz = Nzz;
    }

    void xrot(double theta) {
        double ct = Math.cos(theta *= 0.017453292500000002);
        double st = Math.sin(theta);
        float Nyx = (float)((double)this.yx * ct + (double)this.zx * st);
        float Nyy = (float)((double)this.yy * ct + (double)this.zy * st);
        float Nyz = (float)((double)this.yz * ct + (double)this.zz * st);
        float Nzx = (float)((double)this.zx * ct - (double)this.yx * st);
        float Nzy = (float)((double)this.zy * ct - (double)this.yy * st);
        float Nzz = (float)((double)this.zz * ct - (double)this.yz * st);
        this.yx = Nyx;
        this.yy = Nyy;
        this.yz = Nyz;
        this.zx = Nzx;
        this.zy = Nzy;
        this.zz = Nzz;
    }

    void zrot(double theta) {
        double ct = Math.cos(theta *= 0.017453292500000002);
        double st = Math.sin(theta);
        float Nyx = (float)((double)this.yx * ct + (double)this.xx * st);
        float Nyy = (float)((double)this.yy * ct + (double)this.xy * st);
        float Nyz = (float)((double)this.yz * ct + (double)this.xz * st);
        float Nxx = (float)((double)this.xx * ct - (double)this.yx * st);
        float Nxy = (float)((double)this.xy * ct - (double)this.yy * st);
        float Nxz = (float)((double)this.xz * ct - (double)this.yz * st);
        this.yx = Nyx;
        this.yy = Nyy;
        this.yz = Nyz;
        this.xx = Nxx;
        this.xy = Nxy;
        this.xz = Nxz;
    }

    void mult(Matrix3D rhs) {
        float lxx = this.xx * rhs.xx + this.yx * rhs.xy + this.zx * rhs.xz;
        float lxy = this.xy * rhs.xx + this.yy * rhs.xy + this.zy * rhs.xz;
        float lxz = this.xz * rhs.xx + this.yz * rhs.xy + this.zz * rhs.xz;
        float lyx = this.xx * rhs.yx + this.yx * rhs.yy + this.zx * rhs.yz;
        float lyy = this.xy * rhs.yx + this.yy * rhs.yy + this.zy * rhs.yz;
        float lyz = this.xz * rhs.yx + this.yz * rhs.yy + this.zz * rhs.yz;
        float lzx = this.xx * rhs.zx + this.yx * rhs.zy + this.zx * rhs.zz;
        float lzy = this.xy * rhs.zx + this.yy * rhs.zy + this.zy * rhs.zz;
        float lzz = this.xz * rhs.zx + this.yz * rhs.zy + this.zz * rhs.zz;
        this.xx = lxx;
        this.xy = lxy;
        this.xz = lxz;
        this.yx = lyx;
        this.yy = lyy;
        this.yz = lyz;
        this.zx = lzx;
        this.zy = lzy;
        this.zz = lzz;
    }

    void unit() {
        this.xo = 0.0f;
        this.xx = 1.0f;
        this.xy = 0.0f;
        this.xz = 0.0f;
        this.yo = 0.0f;
        this.yx = 0.0f;
        this.yy = 1.0f;
        this.yz = 0.0f;
        this.zo = 0.0f;
        this.zx = 0.0f;
        this.zy = 0.0f;
        this.zz = 1.0f;
    }

    void transform(ArrayList v, ArrayList tv) {
        ListIterator lit = v.listIterator();
        while (lit.hasNext()) {
            float[] vertex = (float[])lit.next();
            float x = vertex[0];
            float y = vertex[1];
            float z = vertex[2];
            float tx = x * this.xx + y * this.xy + z * this.xz + this.xo;
            float ty = x * this.yx + y * this.yy + z * this.yz + this.yo;
            float tz = x * this.zx + y * this.zy + z * this.zz + this.zo;
            tv.add(new int[]{(int)tx, (int)ty, (int)tz});
        }
    }

    void transform(float[] v, float[] tv) {
        float lxx = this.xx;
        float lxy = this.xy;
        float lxz = this.xz;
        float lxo = this.xo;
        float lyx = this.yx;
        float lyy = this.yy;
        float lyz = this.yz;
        float lyo = this.yo;
        float lzx = this.zx;
        float lzy = this.zy;
        float lzz = this.zz;
        float lzo = this.zo;
        float x = v[0];
        float y = v[1];
        float z = v[2];
        tv[0] = x * lxx + y * lxy + z * lxz + lxo;
        tv[1] = x * lyx + y * lyy + z * lyz + lyo;
        tv[2] = x * lzx + y * lzy + z * lzz + lzo;
    }

    void rotate(ArrayList v, ArrayList tv) {
        float lxx = this.xx;
        float lxy = this.xy;
        float lxz = this.xz;
        float lyx = this.yx;
        float lyy = this.yy;
        float lyz = this.yz;
        float lzx = this.zx;
        float lzy = this.zy;
        float lzz = this.zz;
        ListIterator lit = v.listIterator();
        while (lit.hasNext()) {
            float[] vertex = (float[])lit.next();
            float x = vertex[0];
            float y = vertex[1];
            float z = vertex[2];
            tv.add(new float[]{x * lxx + y * lxy + z * lxz, x * lyx + y * lyy + z * lyz, x * lzx + y * lzy + z * lzz});
        }
    }
}

