/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

class DrawCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    private ThreeD parent;
    private Image i = null;
    private BufferedImage il;
    private BufferedImage ir = null;
    private Graphics gg = null;
    private Graphics2D gl;
    private Graphics2D gr = null;
    private int w;
    private int h;
    public Model3D md;
    private Matrix3D amat;
    private Matrix3D tmat;
    private boolean painted = false;
    private int prevx;
    private int prevy;
    private float xtheta;
    private float ytheta;
    private String message;
    File openDir;
    File saveDir;

    public void destroy() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public void check() {
        if (this.md != null) {
            this.md.printPrimesUsed();
        }
    }

    public DrawCanvas(ThreeD thisparent) {
        this.parent = thisparent;
        this.amat = new Matrix3D();
        this.tmat = new Matrix3D();
        this.w = 800;
        this.h = 600;
        this.amat.xrot(-140.0);
        this.amat.yrot(20.0);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setSize(this.w, this.h);
        this.openDir = null;
        this.saveDir = null;
    }

    public void ReadModel() {
        FileInputStream is = null;
        this.message = null;
        try {
            JFileChooser myChooser = new JFileChooser(this.openDir);
            int retValue = myChooser.showOpenDialog(this.parent);
            if (retValue == 0) {
                this.openDir = myChooser.getCurrentDirectory();
                File f = myChooser.getSelectedFile();
                is = new FileInputStream(f);
                this.md = new Model3D(is);
            }
        }
        catch (FileFormatException | IOException e) {
            this.md = null;
            this.message = e.getMessage();
            System.out.println("io exception");
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.md != null) {
            this.md.findBB();
        }
    }

    public void NewModel() {
        this.w = this.getSize().width;
        this.h = this.getSize().height;
        if (this.w == 0 || this.h == 0) {
            return;
        }
        if (this.i == null) {
            this.i = this.createImage(this.w, this.h);
        }
        if (this.ir == null) {
            this.ir = new BufferedImage(this.w, this.h, 2);
        }
        if (this.il == null) {
            this.il = new BufferedImage(this.w, this.h, 2);
        }
        this.ReadModel();
        if (this.md != null) {
            this.md.setWH(this.w, this.h);
            this.resetImage();
            this.parent.checkButton.setEnabled(true);
            this.parent.thicknessCheck.setEnabled(true);
            this.parent.glassesChoice.setEnabled(true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevx = e.getX();
        this.prevy = e.getY();
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.tmat.unit();
        this.xtheta = (float)(this.prevy - y) * 360.0f / (float)this.w;
        this.ytheta = (float)(this.prevx - x) * 360.0f / (float)this.h;
        this.tmat.xrot(this.xtheta);
        this.tmat.yrot(this.ytheta);
        this.amat.mult(this.tmat);
        if (this.painted) {
            this.painted = false;
            this.resetImage();
        }
        this.prevx = x;
        this.prevy = y;
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void resetImage() {
        this.gg = this.i.getGraphics();
        this.gg.setColor(Color.white);
        this.gg.fillRect(0, 0, this.w, this.h);
        this.md.drawGlasses = this.parent.glassesChoice.getGlasses();
        this.md.isGreen = this.parent.glassesChoice.isGreen();
        this.md.thickLines = this.parent.thicknessCheck.getThickness();
        if (this.md.drawGlasses) {
            this.md.eyeDistance = this.parent.eyeSlider.getEyeDistance();
            this.md.modelInFront = this.parent.placeChoice.getModelInFront();
            this.gl = this.il.createGraphics();
            this.drawImage(this.gl, true);
            this.gr = this.ir.createGraphics();
            this.drawImage(this.gr, false);
        } else {
            this.drawImage(this.gg);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.md != null) {
            if (this.md.drawGlasses) {
                Graphics2D g2d = (Graphics2D)g;
                this.gr.setComposite(AlphaComposite.getInstance(3, 0.5f));
                this.gr.drawImage((Image)this.il, 0, 0, null);
                g2d.drawImage((Image)this.ir, 0, 0, this);
                this.painted = true;
            } else {
                g.drawImage(this.i, 0, 0, this);
                this.painted = true;
            }
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.w, this.h);
        }
    }

    public void drawImage(Graphics2D g, boolean right) {
        if (this.md != null) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.w, this.h);
            if (right) {
                this.md.mat.unit();
                this.md.mat.mult(this.amat);
                this.md.paint(g, right);
            } else {
                this.md.paint(g, right);
            }
        } else if (this.message != null) {
            this.drawError(g);
        }
    }

    public void drawError(Graphics2D g) {
        int j;
        g.setColor(Color.black);
        g.drawString("Error in model:", 3, 20);
        int thisLength = this.message.length();
        for (j = 0; j < thisLength - 40; j += 40) {
            g.drawString(this.message.substring(j, j + 40), 10, 40 + j / 2);
        }
        g.drawString(this.message.substring(j, thisLength), 10, 40 + j / 2);
    }

    public void drawError(Graphics g) {
        int j;
        g.setColor(Color.black);
        g.drawString("Error in model:", 3, 20);
        int thisLength = this.message.length();
        for (j = 0; j < thisLength - 40; j += 40) {
            g.drawString(this.message.substring(j, j + 40), 10, 40 + j / 2);
        }
        g.drawString(this.message.substring(j, thisLength), 10, 40 + j / 2);
    }

    public void drawImage(Graphics g) {
        if (this.md != null) {
            this.md.mat.unit();
            this.md.mat.mult(this.amat);
            this.md.paint(g);
        } else if (this.message != null) {
            this.drawError(g);
        }
    }

    public void saveImage() {
        if (this.saveDir == null) {
            this.saveDir = this.openDir;
        }
        JFileChooser fileChooser = new JFileChooser(this.saveDir);
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Images *.png *.gif", "png", "gif"));
        int retvalue = fileChooser.showSaveDialog(this.parent);
        if (retvalue == 0) {
            int length;
            File file = fileChooser.getSelectedFile();
            this.saveDir = fileChooser.getCurrentDirectory();
            String name = file.getName().toLowerCase();
            String ext = name.substring((length = name.length()) - 3);
            if ("png".equals(ext) | "gif".equals(ext)) {
                this.writeImage(ext, file);
            } else {
                name = name.concat(".png");
                file = new File(this.saveDir, name);
                this.writeImage("png", file);
            }
        }
    }

    public void writeImage(String ext, File Thisfile) {
        BufferedImage bi = new BufferedImage(this.w, this.h, 2);
        Graphics2D ig2 = bi.createGraphics();
        this.paint(ig2);
        try {
            ImageIO.write((RenderedImage)bi, ext, Thisfile);
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

